function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        const temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    return array;
}

const numDatasets = 24;
const datasetOrder = shuffleArray(Array.from(Array(numDatasets).keys())); // [ 0, 1, 2, ... 23 ]
const variationOrder = shuffleArray([1, 2, 3]); //NEW


console.log(variationOrder); //NEW
console.log(datasetOrder);

// update the HTML elements for the current data set
function updateElements() {
    const currentDataset = datasetOrder[currentIndex % numDatasets];
    const currentVariation = variationOrder[Math.floor(currentIndex / numDatasets)];
    console.log(`updating dataset for { :index => ${currentIndex}, :dataset => ${currentDataset}, :variation => ${currentVariation}`);

    const thevid = document.querySelector("video#thevid");
    const theimg = document.querySelector("img#theimg");
    const thesnd = document.querySelector("audio#thesnd");
    var countertext = document.getElementById("counteramount");
    var distributortext = document.getElementById("distributoramount");
    thevid.pause();
    thesnd.pause();
    if (currentIndex >= numDatasets * variationOrder.length) {
        document.querySelector("#test").classList.add("hidden");
        alert("The Test is complete, please let the examiner take over now, thank you!");
        document.querySelector("textarea#output").classList.remove("hidden");
        const name = prompt("Please enter participant Identifier to be used as Filename:");
        downloadfile(generateCsv(recordedGuesses), `${name}.csv`, 'text/csv');
        return;
    }

    distributorvalue = 71 - currentIndex;
    countertext.innerHTML = `${currentIndex}/71`;
    distributortext.innerHTML = `${distributorvalue} Remaining`;
    thevid.setAttribute("src", `data/VMV${currentDataset}.mp4`);
    theimg.setAttribute("src", `data/BentSetPlot${currentDataset}.png`);
    thesnd.setAttribute("src", `data/BPR${currentDataset}.wav`);
    thevid.classList.add("hidden");
    theimg.classList.add("hidden");
    thesnd.classList.add("hidden");

    
    switch(currentVariation){
        case 1:
            theimg.classList.remove("hidden");
            break;
        case 2:
            thesnd.classList.remove("hidden");
            //thesnd.play();
            break;
        case 3:
            thevid.classList.remove("hidden");
            //thevid.play();
            break;
    }

}

function generateCsv(guesses) {
    const meta = "sep=;\r\n";
    const headings = "\"Type\";\"Guess\";\"Dataset\"\r\n";
    const lines = guesses.map(guess => `\"${guess.type}\";\"${guess.guess}\";\"${guess.dataset}\"`).join("\r\n");
    return meta + headings + lines + "\r\n";
}

let currentIndex = 0;
let recordedGuesses = [];

function getType() {
    const thevid = document.querySelector("video#thevid");
    const theimg = document.querySelector("img#theimg");
    const thesnd = document.querySelector("audio#thesnd");

    if (!thevid.classList.contains("hidden")) {
        return "combined";
    }
    if (!theimg.classList.contains("hidden")) {
        return "visual";
    }
    if (!thesnd.classList.contains("hidden")) {
        return "auditory";
    }
    return "unknown";
}

function onGuessConfirm(event) {
    event.preventDefault();
    const guessInput = document.querySelector("input#entryGuess");
    let guessed = parseFloat(guessInput.value.replace(",", "."));
    if (guessed.toString() === "NaN") {
        alert("please enter a number");
        return;
    }
    if (guessed < -1.0 || guessed > 1.0) {
        alert("your guess needs to be between -1.0 and 1.0")
        guessInput.value = "";
        return;
    }
    recordedGuesses.push({ type: getType(), guess: guessed, dataset: datasetOrder[currentIndex % numDatasets] });
    console.log("elements: " + JSON.stringify(recordedGuesses));
    document.querySelector("textarea#output").value = JSON.stringify(recordedGuesses);
    document.querySelector("textarea#output").classList.add("hidden");
    guessInput.value = "";
    currentIndex++;
    updateElements();
}

function downloadfile(content, fileName, contentType){

    var a = document.createElement("a");
    var file =  new Blob([content], {type: contentType});
    a.href = URL.createObjectURL(file);
    a.download = fileName;
    a.click();

}

window.addEventListener("DOMContentLoaded", () => {
    document.querySelector("button#confirmGuess").addEventListener("click", onGuessConfirm);
    document.querySelector("input#entryGuess").addEventListener("keydown", (ev) => {
        if (ev.key !== "Enter") {
            return;
        }
        ev.preventDefault();

        onGuessConfirm(ev);
    });
    updateElements();
});
